<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Homepage extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $lang = isset($this->session->userdata['language']) ? $this->session->userdata['language'] : 'slo';
        $this->lang->load('site', $lang);
        $this->load->model("Homepage_model");
        $this->load->model("Email_model");
    }

    public function index() {

        $this->data['active'] = 'homepage';

        $this->data['main_content'] = 'index';
        $this->load->view('template', $this->data);
    }

    public function podjetje() {
        $this->data['active'] = 'podjetje';

        $this->data['main_content'] = 'podjetje';
        $this->load->view('template', $this->data);
    }

    public function zaposlitev() {
        $this->data['active'] = 'zaposlitev';

        $this->data['main_content'] = 'zaposlitev';
        $this->load->view('template', $this->data);
    }

    public function langswitch($lang) {
        $this->session->set_userdata('language', $lang);
        redirect();
    }

    public function poslji() {
        
        $email = 'aleksanra.tesic@tehmont.si';
        
        $data['ime'] = $this->input->post('ime');
        $data['kontakt'] = $this->input->post('kontakt');
        $data['delovno_mesto'] = $this->input->post('delovno_mesto');
        $data['delovne_izkusnje'] = $this->input->post('delovne_izkusnje');
        
        $this->Email_model->send(
                'info@tehmont.si', 
                'Tehmont web form', 
                $email, 
                'Prijava na delovno mesto', 
                "zaposlitev_email", 
                array("{ime}", "{kontakt}", "{delovno_mesto}", "{delovne_izkusnje}"), 
                array($data['ime'], $data['kontakt'], $data['delovno_mesto'],$data['delovne_izkusnje'])
        );
    }

}
