<?php $this->load->view('includes/header'); ?>
<!-- Static navbar -->
<nav class="navbar navbar-default navbar-fixed-top">
    <div class="navbar-header">
        <a class="navbar-brand" href="<?php echo site_url(); ?>">
            <img alt="Tehmont" src="<?php echo base_url('img/logo_tehmont.jpg'); ?>">
        </a>
        <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
            <span class="sr-only">Toggle navigation</span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
        </button>
    </div>
    <div id="navbar" class="navbar-collapse collapse">
        <ul class="nav navbar-nav">
            <li class="<?php echo ($active == 'podjetje') ? 'active' : ''; ?>"><a href="<?php echo base_url('podjetje'); ?>"><?php echo $this->lang->line('podjetje'); ?></a></li>
            <li class="menu-scroll <?php echo ($active == 'dejavnosti') ? 'active' : ''; ?>" data-menu="dejavnosti"><a href="<?php echo base_url('dejavnosti'); ?>"><?php echo $this->lang->line('dejavnosti'); ?></a></li>
            <li class="menu-scroll <?php echo ($active == 'reference') ? 'active' : ''; ?>" data-menu="reference"><a href="<?php echo base_url('reference'); ?>"><?php echo $this->lang->line('reference'); ?></a></li>
            <li class="<?php echo ($active == 'zaposlitev') ? 'active' : ''; ?>"><a href="<?php echo base_url('zaposlitev'); ?>"><?php echo $this->lang->line('zaposlitev'); ?></a></li>
            <li class="menu-scroll <?php echo ($active == 'kontakt') ? 'active' : ''; ?>" data-menu="kontakt"><a href="<?php echo base_url('kontakt'); ?>"><?php echo $this->lang->line('kontakt'); ?></a></li>
        </ul>
        <ul class="nav navbar-nav navbar-right langswitch">
            <li>
                <a class="slo-flag <?php echo (isset($this->session->userdata['language']) && $this->session->userdata['language'] == 'slo') ? 'active' : ''; ?>" href='homepage/langswitch/slo'></a>
            </li>
            <li>
                <a class="en-flag <?php echo (isset($this->session->userdata['language']) && $this->session->userdata['language'] == 'en') ? 'active' : ''; ?>" href='homepage/langswitch/en'></a>
            </li>
            <li>
                <a class="de-flag <?php echo (isset($this->session->userdata['language']) && $this->session->userdata['language'] == 'de') ? 'active' : ''; ?>" href='homepage/langswitch/de'></a>
            </li>
        </ul>
    </div>
</nav>
<?php $this->load->view($main_content); ?>
<div class="sredina">
    <div class="storitve">
        <a name="dejavnosti"></a>
        <h2><?php echo $this->lang->line('storitve_title'); ?></h2>
        <div class="storitve-inner">
            <div class="row">
                <div class="col-md-6 storitev">
                    <img class="img img-responsive" src="<?php echo base_url('img/storitev_strojne_instalacije.jpg'); ?>">
                    <div class="arrow-up"></div>
                    <h3><?php echo $this->lang->line('storitev1_title'); ?></h3>
                    <p><?php echo $this->lang->line('storitev1_content'); ?></p>
                </div>
                <div class="col-md-6 storitev">
                    <img class="img img-responsive" src="<?php echo base_url('img/storitev_elektro_instalacije.jpg'); ?>">
                    <div class="arrow-up"></div>
                    <h3><?php echo $this->lang->line('storitev2_title'); ?></h3>
                    <p><?php echo $this->lang->line('storitev2_content'); ?></p>
                </div>
                <div class="col-md-6 storitev">
                    <img class="img img-responsive" src="<?php echo base_url('img/storitev_varilska_dela.jpg'); ?>">
                    <div class="arrow-up"></div>
                    <h3><?php echo $this->lang->line('storitev3_title'); ?></h3>
                    <p><?php echo $this->lang->line('storitev3_content'); ?></p>
                </div>
                <div class="col-md-6 storitev">
                    <img class="img img-responsive" src="<?php echo base_url('img/storitev_montazne_konstrukcije.jpg'); ?>">
                    <div class="arrow-up"></div>
                    <h3><?php echo $this->lang->line('storitev4_title'); ?></h3>
                    <p><?php echo $this->lang->line('storitev4_content'); ?></p>
                </div>
            </div>
        </div>
        <h4><?php echo $this->lang->line('storitve_bottom'); ?></h4>
    </div>
    <div class="reference">
        <a name="reference"></a>
        <div class="line"></div>
        <h2><?php echo $this->lang->line('reference'); ?></h2>
        <div class="reference-map">
            <div class="referenca-map-text">
                <p><b><?php echo $this->lang->line('reference-text'); ?></b></p>
                <ul>
                    <li><?php echo $this->lang->line('reference1'); ?></li>
                    <li><?php echo $this->lang->line('reference2'); ?></li>
                    <li><?php echo $this->lang->line('reference3'); ?></li>
                    <li><?php echo $this->lang->line('reference4'); ?></li>
                </ul>
            </div>
            <img src="img/reference_zemljevid.jpg" class="img img-responsive">
        </div>
        <div class="reference-inner">
            <?php $this->load->view('reference'); ?>
        </div>
    </div>
</div>
<div class="footer">
    <div class="sredina">
        <a name="kontakt"></a>
        <div class="line"></div>
        <img class="logo" alt="Tehmont" src="<?php echo base_url('img/logo_tehmont.jpg'); ?>">
        <div class="foot-text">
            <p><b>Tehmont projekt, d.o.o.,</b> Vodovodna ulica 11, 2000 Maribor
                <span class="red">/</span>
                Tel: +386 2 251 84 88
                <span class="red">/</span>
                Fax: +386 2 251 84 88
                <span class="red">/</span>
                Email: info@tehmontprojekt.si
            </p>
        </div>
        <div class="kontakt">
            <div class="col-md-4">
                <h3><?php echo $this->lang->line('administracija'); ?></h3>
                <p><a href="mailto:aleksandra.tesic@tehmontprojekt.si">aleksandra.tesic@tehmontprojekt.si</a></p>
                <p>+386 (0)2 251 84 88</p>
            </div>
            <div class="col-md-4">
                <h3><?php echo $this->lang->line('tehnicna'); ?></h3>
                <p><a href="mailto:mico.tesic@tehmontprojekt.si">mico.tesic@tehmontprojekt.si</a></p>
                <p>+386 (0)31 304 744</p>
            </div>
            <div class="col-md-4">
                <h3><?php echo $this->lang->line('vodstvo'); ?></h3>
                <p><a href="mailto:office@tehmontprojekt.si">office@tehmontprojekt.si</a></p>
                <p>+386 (0)41 664 644</p>
            </div>
        </div>
    </div>
</div>
<?php $this->load->view('includes/footer'); ?>

